//---------------------------------------------------------------------------
#ifndef aRelatywH
#define aRelatywH

#include "geometria.h"          //klasy TPunkt, TLinia
//---------------------------------------------------------------------------
//	Projekcja obiektw 3-wymiarowych na paski ekran.
//	Obiekt posiada dwa konstruktory.
//	Potrafi znale ekranowe miejsce punktu,
//	wykreli lini i czworokt.
class TRelatyw3d
{
 private:
    double odl_obserwatora;
    TPunkt obserwator;                          //pozycja obserwatora
    double odl_ekr, sf, cf, st, ct, A, B, C, D; //wspczynniki pomocnicze
    double beta, gamma;                         //parametry relatywistyczne
    TCanvas *cnv;                               //wskanik do aparatu krelcego
    bool wylicz_punkt_relatyw( int &xe, int &ye, TPunkt p);

 public:
    TRelatyw3d(                                 //konstruktor
        TPunkt Aobserwator,                     //pozycja obserwatora
        int xe0, int ye0, int eszer, int ewys,  //okno ekranowe
        double v,                               //prdko w kierunku osi 'x'
        TCanvas *Acnv,                          //aparat krelcy
        double Aodl_ekr=0.5,
        double szer_ekr=0, double wys_ekr=0);   //fizyczny opis ekranu

    bool punkt_relatyw( TPunkt p, TColor kolor = clBlack);

                                                //__closure - borlandowski modyfikator
                                                //wskanika do funkcji - elementu klasy
                                                //Oprcz adresu dodaje do wskanika informacj
                                                //o macierzystym obiekcie.
    bool linia_relatyw( TPunkt p1, TPunkt p2, int il_podzial,
        void (__closure* kolor_fun)( TCanvas *, int)=NULL);
    bool uproszczona_linia_relatyw( TPunkt p1, TPunkt p2,
        int il_podzial, TColor kolor);

    bool czworokat_relatyw( TPunkt p1, TPunkt p2, TPunkt p3, TPunkt p4, int il_podzial,
        void (__closure* kolor_fun)( TCanvas *, int, int)=NULL);
    bool uproszczony_czworokat_relatyw( TPunkt p1, TPunkt p2, TPunkt p3, TPunkt p4,
        int il_podzial, TColor k1, TColor k2);
};
#endif
